; Disassembly of the file "Fun With Vectors - Ziggy
; (1985)(Richard Degler)(PD)(proto)[no bouncing].bin"
; 
; CPU Type: Z80 - for The Bally Professional Arcade
; 
; Programed and commented by: Richard C. Degler
; From Scratch with a whole lot of hand editing!
; 
; Re-created with dZ80 1.50 and commented by: RCD
; 
; on Tuesday, 04 of November 2008 at 05:13 AM
; Assembles correctly with: Zmac -i FUNWIT~1.ASM
; Matches ePROM except for empty bytes at the end!
;


; Notes on "Fun with Vectors - Ziggy" from circa 1985:
;
;
; Moves one pixel per sixtieth of a second by Joystick ONE
; and continues in the same direction with rubber walls on
; trigger in.
;
; VECT repeats until vbTIMB = 0, adding delta to X and Y POS.
; words (if vbSTAT bit 7 is set.)  Original vbTIMB returns
; in C and Zero Flag is set if no move made.
;
; VWRITR draws pattern displaced from high bytes of POSition
; and uses vbMREG Magic Value.  The Absolute Address is ret-
; urned in DE, which must be stored in vbOADD for VBLANK use.
; vbBLNK gets set.
;
; VBLANK blanks a box beginning at vbOADD (flopped if vbMREG
; bit 6 set) - but only if vbBLNK (bit 6 of vbSTAT) is set,
; which becomes reset when through.  Blank one byte wider
; than pattern to cover shifted pictures.
;


; note: Original programming done using an R&L 64kRAM board,
; BlueRamBasic 1.1 copy utilities and a MicroSwitch keyboard.
; NO Assembler - all Machine Code from a Z80 reference card! 
; Comments were on paper listing, in decimal, changed to HEX
; & variables given names. [new comments in square brackets]
;

       NOLIST
       INCLUDE "HVGLIB.H"

;
; *********************************************************
; *                                                       *
; *           IMPORTANT: Conditional Assembly!            *
; *                                                       *
; *  This code can assemble into two different binary     *
; *  files.  One assembly is for "TRIGGER PULL" and the   *
; *  other is for the newer "JUST JOYSTICK" version.      *
; *                                                       *
; *  The default is for the original.  To assemble for    *
; *  non-triggered code, change OLD EQU YES to OLD EQU NO *
; *                                                       *
; *********************************************************

YES     EQU    1
NO      EQU    0
OLD     EQU    YES


; ********************* Defines for Variables
; RESET   EQU     $0000

; [NORMEM + (100 lines * BYTEPL) + 1 (added since VBLANKs too wide)]
ZIGGY   EQU     $4FA1     ; VECTOR BLOCK Base Address [below screen]

; [ZVB naming convention is Ziggy Vector Block with offset value]
ZVBMR   EQU     ZIGGY+VBMR      ; 2 bytes MAGIC REGISTER and STATUS
ZVBTIMB EQU     ZIGGY+VBTIMB    ; TIME BASE
ZVBDX   EQU     ZIGGY+VBDXL     ; word DELTA X
ZVBXPOS EQU     ZIGGY+VBXL      ; word X COORD
ZVBXCHK EQU     ZIGGY+VBXCHK    ; X CHECK FLAGS
ZVBDY   EQU     ZIGGY+VBDYL     ; word DELTA Y
ZVBYPOS EQU     ZIGGY+VBYL      ; word Y COORD
ZVBYCHK EQU     ZIGGY+VBYCHK    ; Y CHECK FLAGS
ZVBOADD EQU     ZIGGY+VBOAL     ; word OLD ADDRESS OF L.O.


        LIST
        ORG     FIRSTC

; ********************* First Address in Cartridge
; L2000:
        JP      L2065         ; AUTOSTART JMP [to RUN FWVZ]


; ********************* COLOR Table data
; COLTAB:
L2003:  DB      $FB           ; &(7) = BLUE  [Color 3 Left side]
        DB      $07           ; &(6) = WHITE  [Color 2 Left]
        DB      $07           ; &(5) = WHITE  [Color 1 Left]
        DB      $07           ; &(4) = WHITE  [Color 0 Left]
                              ; &(3 thru 0) = Garbage


; ********************* Vector Block LIMIT Table data
; VLIMIT:
L2007:  DB      $00           ; XLL  [X limit Lower]
        DB      $87           ; XLU  [X limit Upper]
        DB      $00           ; YLL  [Y limit Lower]
        DB      $48           ; YLU  [Y limit Upper]


; ********************* "ZIGGY" Pattern data
; PATTERN:
L200B:  DB      $00           ; X Disp.
        DB      $00           ; Y Disp.
        DB      $03           ; X Size [in bytes]
        DB      $1C           ; Y Size
        DB      $00,$EE,$00   ; - . . . . . . . .  X X X . X X X .  . . . . . . . .
        DB      $03,$FE,$00   ; - . . . . . . X X  X X X X X X X .  . . . . . . . .
        DB      $0F,$9F,$80   ; - . . . . X X X X  X . . X X X X X  X . . . . . . .
        DB      $1F,$0D,$C0   ; - . . . X X X X X  . . . . X X . X  X X . . . . . .
        DB      $3F,$00,$C2   ; - . . X X X X X X  . . . . . . . .  X X . . . . X .
        DB      $7E,$00,$42   ; - . X X X X X X .  . . . . . . . .  . X . . . . X .
        DB      $FC,$8C,$E2   ; - X X X X X X . .  X . . . X X . .  X X X . . . X .
        DB      $7D,$BE,$E2   ; - . X X X X X . X  X . X X X X X .  X X X . . . X .
        DB      $7D,$8C,$D1   ; - . X X X X X . X  X . . . X X . .  X X . X . . . X
        DB      $7D,$98,$51   ; - . X X X X X . X  X . . X X . . .  . X . X . . . X
        DB      $3D,$00,$35   ; - . . X X X X . X  . . . . . . . .  . . X X . X . X
        DB      $3D,$66,$B9   ; - . . X X X X . X  . X X . . X X .  X . X X X . . X
        DB      $3D,$3F,$F0   ; - . . X X X X . X  . . X X X X X X  X X X X . . . .
        DB      $3C,$8F,$C2   ; - . . X X X X . .  X . . . X X X X  X X . . . . X .
        DB      $3C,$DF,$1E   ; - . . X X X X . .  X X . X X X X X  . . . X X X X .
        DB      $0D,$6F,$F0   ; - . . . . X X . X  . X X . X X X X  X X X X . . . .
        DB      $0E,$B7,$F8   ; - . . . . X X X .  X . X X . X X X  X X X X X . . .
        DB      $00,$BF,$FB   ; - . . . . . . . .  X . X X X X X X  X X X X X . X X
        DB      $00,$BF,$C0   ; - . . . . . . . .  X . X X X X X X  X X . . . . . .
        DB      $03,$43,$18   ; - . . . . . . X X  . X . . . . X X  . . . X X . . .
        DB      $1D,$40,$18   ; - . . . X X X . X  . X . . . . . .  . . . X X . . .
        DB      $02,$40,$18   ; - . . . . . . X .  . X . . . . . .  . . . X X . . .
        DB      $02,$00,$30   ; - . . . . . . X .  . . . . . . . .  . . X X . . . .
        DB      $07,$00,$30   ; - . . . . . X X X  . . . . . . . .  . . X X . . . .
        DB      $06,$E1,$F0   ; - . . . . . X X .  X X X . . . . X  X X X X . . . .
        DB      $0C,$1E,$30   ; - . . . . X X . .  . . . X X X X .  . . X X . . . .
        DB      $0C,$00,$70   ; - . . . . X X . .  . . . . . . . .  . X X X . . . .
        DB      $00,$00,$60   ; - . . . . . . . .  . . . . . . . .  . X X . . . . .


; ********************* Interrupt VECTOR jump address
; VECTOR:
L2063:  DW      L20C3         ; [address of] INTRPT [routine]


; ********************* Do FUN WITH VECTORS - ZIGGY starting here
; RUNFWVZ
L2065:
        DI
        LD      SP,$5000      ; (DON'T FLUSH URINAL)

        SYSSUK  COLSET        ; [Set Colors to ...]
        DW      L2003         ; COLTAB

        SYSSUK  FILL          ; [Fill a contiguous area to 0's]
        DW      NORMEM        ; [starting at] SCREEN
        DW      $0FAF         ; [Count = (100 lines * BYTEPL) + 15]
                              ; [should be 1 more to clear full VB]
        DB      $00           ; DATA

        SYSSUK  SETOUT        ; [Set some OutPorts as follows:]
        DB      $C8           ; &(10) = 200  [VERBL = 100 * 2]
        DB      $2C           ; &(9) = 44  [HORCB = 176 pixels / 4]
        DB      $0C           ; &(14) = 12  [INMOD = Screen Ints.]

        LD      A,L2063 / 256 ; Int. Vector at L2063
        LD      I,A
        LD      A,$63         ; &(13) = VECTOR & $00FF
        OUT     (INFBK),A
        LD      A,$7F         ; &(15) = 127  [Int. Line number]
        OUT     (INLIN),A
        IM      2             ; [Interrupt Mode = Bally HVG style]

        LD      A,$0C         ; &(25) = 12  [eXpand to Color 3 on 0]
        OUT     (XPAND),A

        LD      HL,$8008      ; vbMR = 8  [set EXPAND ON and ...]
            ; [1 << VBSACT (VECTOR ACTIVE bit) loaded into vbSTAT]
        LD      (ZIGGY),HL    ; STAT = 128
        LD      A,$01         ; vbTIMB = 1 [once per Interrupt call]
        LD      (ZVBTIMB),A
        LD      HL,$4200      ; vbXpos = 66.00 [2 bytes resolution]
        LD      (ZVBXPOS),HL
        LD      A,(1 << VBCLMT) or (1 << VBCREV)  ; vbXchk = 3
            ;  [for DO LIMIT CHECKING and REVERSE DELTA ON LIMIT ATTAIN]
        LD      (ZVBXCHK),A
        LD      HL,$2300      ; vbYpos = 35.00 [2 bytes]
        LD      (ZVBYPOS),HL
        LD      (ZVBYCHK),A   ; vbYchk [= vbXchk]

;LOOP:                    ; *** LOOP [to HERE] ***
L20AA:  EI
        HALT                  ; [Wait HERE] until interrupt
        IN      A,(SW0)       ; [read &(16) for Joystick ONE]
IF OLD                    ; [!!! Macro Assembler directive !!!]
        BIT     4,A           ; Trig ? [Hold in to move or ...]
        JR      NZ,L20AA                ; (-$08)
ELSE
        AND     $0F           ; [do if Joystick NOT centered ?]
        JR      Z,L20AA                 ; (-$08)
ENDIF
        LD      B,A           ; [fake a SENTRY return code in B]
        SYSSUK  MSKTD         ; [returns Deltas based on Joystick]
        DW      $0100         ; +DeltaX = 1.00 [byte . byte]
        DB      $00           ; Flop Flag = 0  [X axis NOT reversed]
        DW      $0100         ; +DeltaY = 1.00 [2 bytes]

        LD      (ZVBDY),HL    ; [save +1, 0 or -1] vbDeltaY [and ...]
        EX      DE,HL
        LD      (ZVBDX),HL    ; vbDeltaX [then ALWAYS JUMP] to LOOP
        JR      L20AA                   ; (-$19)


; ********************* INTERRUPT ROUTINE
; INTRPT:
L20C3:  SYSSUK  VECT          ; [updates VB and returns TB used in C]
        DW      ZIGGY         ; vbMR [Vector Block base address]
        DW      L2007         ; VLIMIT [table for bounding box]

        LD      A,C           ; [save original TB to re-set] vbTIMB
        LD      (ZVBTIMB),A   ; to RET on NO change ?
        JR      Z,L20DF                 ; (+$10)

        SYSSUK  VBLANK        ; [gets old address from VB and blanks]
        DW      ZIGGY         ; vbMR [Vector Block base]
        DB      $07           ; 7 bytes W[ide]
        DB      $1C           ; 28 H[eight]

        SYSSUK  VWRITR        ; [Write Relative from Vector Block]
        DW      ZIGGY         ; vbMR [base]
        DW      L200B         ; PATTERN [aka Mr. ZIG-ZAG logo]

        EX      DE,HL
        LD      (ZVBOADD),HL  ; [save for VBLANK in] vbOADD

L20DF:  RET                   ; urn     



; ********************* Filler Bytes for 2K EPROM
;
; L20E0:  [should be unburned $FF / 255 / -1's instead!!]
        DEFS    $0720         ; 1824 NOP'd Zero bytes


; ********************* End of Z80 Source Code
;
                              ; $27FF = End of Code
